/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.ServerConfig;
import sun.net.httpserver.ServerImpl;

abstract class LeftOverInputStream
extends FilterInputStream {
    ExchangeImpl t;
    ServerImpl server;
    protected boolean closed = false;
    protected boolean eof = false;
    byte[] one = new byte[1];

    public LeftOverInputStream(ExchangeImpl exchangeImpl, InputStream inputStream) {
        super(inputStream);
        this.t = exchangeImpl;
        this.server = exchangeImpl.getServerImpl();
    }

    public boolean isDataBuffered() throws IOException {
        assert (this.eof);
        return super.available() > 0;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.eof) {
            this.eof = this.drain(ServerConfig.getDrainAmount());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isEOF() {
        return this.eof;
    }

    protected abstract int readImpl(byte[] var1, int var2, int var3) throws IOException;

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int n = this.readImpl(this.one, 0, 1);
        if (n == -1 || n == 0) {
            return n;
        }
        return this.one[0] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        return this.readImpl(byArray, n, n2);
    }

    public boolean drain(long l) throws IOException {
        int n = 2048;
        byte[] byArray = new byte[n];
        while (l > 0L) {
            long l2 = this.readImpl(byArray, 0, n);
            if (l2 == -1L) {
                this.eof = true;
                return true;
            }
            l -= l2;
        }
        return false;
    }
}

