using System;
using System.ServiceModel;
using HpSvcW.Authentification;
using HpSvcWDotNet.HpSvcW;

namespace HpSvcWDotNet {
  class TestHpSvcWDotNet {

	public UInt32 AccederOuCreerEnseignant (HpSvcWEnseignantsClient AConnexionEnseignants,
											string ANom,
											string APrenom,
											string ACode,
											string AIdent){

	  UInt32 Result = 0;
	  try {
		if (AIdent != ""){ // se c' un identificativo, accede al docente attraverso l'identificativo
		  Result = AConnexionEnseignants.AccederEnseignantParIdentifiant (AIdent);
		  if (ANom != "") // modifica il cognome se non  vuoto
			AConnexionEnseignants.ModifierNomEnseignant (Result, ANom);
		  if (APrenom != "") // modifica il nome se non  vuoto
			AConnexionEnseignants.ModifierPrenomEnseignant (Result, APrenom);
		  if (ACode != "") // modifica il codice se non  vuoto
			AConnexionEnseignants.ModifierCodeEnseignant (Result, ACode);
		} else { // se non c' l'identificativo, accede al docente attraverso il codice, cognome e nome
		  Result = AConnexionEnseignants.AccederEnseignantParNomPrenomEtCode (ANom,
																			  APrenom,
																			  ACode);
		}
	  } catch {
		try { // crea il docente
		  Result = AConnexionEnseignants.CreerEnseignantAvecIdentifiant (ANom,
																		 APrenom,
																		 ACode,
																		 AIdent);
		} catch {
		  // L'identificativo viene nuovamente definito ma il docente esiste gi nella base dati
		  Result = AConnexionEnseignants.AccederEnseignantParNomPrenomEtCode (ANom,
																			  APrenom,
																			  ACode);
		  if (AIdent != "") // modifica l'identificativo se non  vuoto
			AConnexionEnseignants.ModifierIdentifiantEnseignant (Result, AIdent);
		}
	  }
	  return Result;
	}

	public UInt32 AccederOuCreerDiplome (HpSvcWPromotionsClient AConnexionPromotions,
										 string ALibelle,
										 string ACode,
										 string AIdent){

	  UInt32 Result = 0;
	  try {
		if (AIdent != ""){ // se c' un identificativo, accede al corso attraverso l'identificativo
		  Result = AConnexionPromotions.AccederPromotionParIdentifiant (AIdent);
		  if (ALibelle != "") // modifica il nome se non  vuoto
			AConnexionPromotions.ModifierNomPromotion (Result, ALibelle);
		  if (ACode != "") // modifica il codice se non  vuoto
			AConnexionPromotions.ModifierCodePromotion (Result, ACode);
		} else { // se non c' l'identificativo, accede al corso attraverso il codice e il nome
		  Result = AConnexionPromotions.AccederPromotionParNomEtCode (ALibelle, ACode);
		}
	  } catch {
		try { // crea il corso
		  Result = AConnexionPromotions.CreerPromotionAvecIdentifiant (ALibelle, ACode, AIdent);
		} catch {
		  // L'identificativo viene nuovamente definito ma il corso esiste gi nella base dati
		  Result = AConnexionPromotions.AccederPromotionParNomEtCode (ALibelle, ACode);
		  if (AIdent != "")// modifica l'identificativo se non  vuoto
			AConnexionPromotions.ModifierIdentifiantPromotion (Result, AIdent);
		}
	  }
	  return Result;
	}

	public UInt32 AccederOuCreerPartition (HpSvcWTDOptionsClient AConnexionTDOptions,
										   UInt32 ADiplome,
										   string ALibelle){

	  UInt32 Result = 0;
	  try { // accede alla suddivisione attraverso il corso e il nome
		Result = AConnexionTDOptions.AccederPartitionParPromotionEtNom (ADiplome, ALibelle);
	  } catch {
		try { // altrimenti la crea
		  Result = AConnexionTDOptions.CreerPartitionDeLaPromotion (ADiplome, ALibelle);
		} catch {}
	  }
	  return Result;
	}

	public UInt32 AccederOuCreerTD (HpSvcWTDOptionsClient AConnexionTD,
                                    HpSvcWPromotionsClient AConnexionDiplome,
									string ALibelle,
									string ACode,
									string AIdent){

	  UInt32 Result = 0;
	  string delimStr = "<>"; //<Corso><Suddivisione>Gruppo  // 1 3 4
	  string [] splitLibelle   = null;
	  string [] splitCode      = null;
	  string [] splitIdent     = null;
	  char [] delimiter        = delimStr.ToCharArray();
	  string LTDIdent          = "";
	  string LTDLibelle        = "";
	  string LTDCode           = "";
	  string LPartitionLibelle = "";
	  string LDiplomeIdent     = "";
	  string LDiplomeLibelle   = "";
	  string LDiplomeCode      = "";

	  try {
		splitLibelle = ALibelle.Split (delimiter); // Secondo la sintassi : <nome_del_corso><Suddivisione>nome_del_gruppo
		splitCode    = ACode.Split (delimiter);    // Secondo la sintassi : <codice_del_corso><Suddivisione>codice_del_gruppo
		splitIdent   = AIdent.Split (delimiter);   // Secondo la sintassi : <ident_del_corso><Suddivisione>ident_del_gruppo

		if (splitIdent.Length   == 5){
		  LTDIdent      = splitIdent[4];           // ident_del_gruppo
		  LDiplomeIdent = splitIdent[1];           // ident_del_corso
		}
		if (splitLibelle.Length == 5){
		  LTDLibelle        = splitLibelle[4];     // nome_del_gruppo
		  LDiplomeLibelle   = splitLibelle[1];     // nome_del_corso
		  LPartitionLibelle = splitLibelle[3];     // suddivisione
		}
		if (splitCode.Length    == 5){
		  LTDCode      = splitCode[4];             // codice_del_gruppo
		  LDiplomeCode = splitCode[1];             // codice_del_corso
		}

		try {
		  if (AIdent != ""){  // se c' un identificativo, accede al gruppo attraverso l'identificativo
			Result = AConnexionTD.AccederTDOptionParIdentifiant (LTDIdent);
			if (LTDLibelle != "") // modifica il nome se non  vuoto
			  AConnexionTD.ModifierNomTDOption  (Result, LTDLibelle);
			if (LTDCode != "") // modifica il codice se non  vuoto
			  AConnexionTD.ModifierCodeTDOption (Result, LTDCode);
		  } else { // se non c' l'identificativo, accede al corso, alla suddivisione poi al gruppo attraverso il codice e il nome
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			UInt32 LPartition = AccederOuCreerPartition (AConnexionTD,
														 LDiplome,
														 LPartitionLibelle);
			Result = AConnexionTD.AccederTDParPartitionNomEtCode (LPartition,
																  LTDLibelle,
																  LTDCode);
		  }
		} catch {
		  try { // crea il gruppo
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			UInt32 LPartition = AccederOuCreerPartition (AConnexionTD,
														 LDiplome,
														 LPartitionLibelle);
			Result = AConnexionTD.CreerTDAvecIdentifiant (LPartition,
														  LTDLibelle,
														  LTDCode,
														  LTDIdent);
		  } catch {
			// L'identificativo viene nuovamente definito ma il gruppo esiste gi nella base dati
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			UInt32 LPartition = AccederOuCreerPartition (AConnexionTD,
														 LDiplome,
														 LPartitionLibelle);
			Result = AConnexionTD.AccederTDParPartitionNomEtCode (LPartition,
																  LTDLibelle,
																  LTDCode);
			if (AIdent != "") // modifica l'identificativo se non  vuoto
			 AConnexionTD.ModifierIdentifiantTDOption (Result, LTDIdent);
		  }
		}
	  } catch {}
	  return Result;
	}

	public UInt32 AccederOuCreerOption(HpSvcWTDOptionsClient AConnexionTD,
                                        HpSvcWPromotionsClient AConnexionDiplome,
										string ALibelle,
										string ACode,
										string AIdent){

	  UInt32 Result = 0;
	  string delimStr = "<>"; //<Corso>Opzione  // 1 2
	  string [] splitLibelle = null;
	  string [] splitCode    = null;
	  string [] splitIdent   = null;
	  char [] delimiter      = delimStr.ToCharArray();
	  string LOptionIdent    = "";
	  string LOptionLibelle  = "";
	  string LOptionCode     = "";
	  string LDiplomeIdent   = "";
	  string LDiplomeLibelle = "";
	  string LDiplomeCode    = "";

	  try {
		splitLibelle = ALibelle.Split (delimiter); // Secondo la sintassi : <nome_del_corso>nome_della_opzione
		splitCode    = ACode.Split (delimiter);    // Secondo la sintassi : <codice_del_corso>codice_della_opzione
		splitIdent   = AIdent.Split (delimiter);   // Secondo la sintassi : <Ident_del_corso>Ident_della_opzione

		// Identifiant
		if (splitIdent.Length   == 3){
		  LOptionIdent  = splitIdent[2];           //Ident_della_opzione
		  LDiplomeIdent = splitIdent[1];           //Ident_del_corso
		}
		// Libelle
		if (splitLibelle.Length == 3){
		  LOptionLibelle  = splitLibelle[2];       //nome_della_opzione
		  LDiplomeLibelle = splitLibelle[1];       //nome_del_corso
		}
		// Code
		if (splitCode.Length    == 3){
		  LOptionCode  = splitCode[2];             //codice_della_opzione
		  LDiplomeCode = splitCode[1];             //codice_del_corso
		}

	    try {
		  if (AIdent != ""){ // se c' un identificativo, accede all'opzione attraverso l'identificativo
			Result = AConnexionTD.AccederTDOptionParIdentifiant (LOptionIdent);
			if (LOptionLibelle != "") // modifica il nome se non  vuoto
			  AConnexionTD.ModifierNomTDOption  (Result, LOptionLibelle);
			if (LOptionCode != "")    // modifica il codice se non  vuoto
			  AConnexionTD.ModifierCodeTDOption (Result, LOptionCode);
		  } else { // se non c' l'identificativo, accede al corso poi all'opzione attraverso il codice e il nome
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			Result = AConnexionTD.AccederOptionParPromotionNomEtCode (LDiplome, LOptionLibelle, LOptionCode);
		  }
		} catch {
		  try { // Crea l'opzione
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			Result = AConnexionTD.CreerOptionDeLaPromotionAvecIdentifiant (LDiplome, LOptionLibelle, LOptionCode, LOptionIdent);
		  } catch {
			// L'identificativo viene nuovamente definito ma l'opzione esiste gi nella base dati
			UInt32 LDiplome = AccederOuCreerDiplome (AConnexionDiplome,
													 LDiplomeLibelle,
													 LDiplomeCode,
													 LDiplomeIdent);
			Result = AConnexionTD.AccederOptionParPromotionNomEtCode (LDiplome, LOptionLibelle, LOptionCode);
			if (AIdent != "") // modifica l'identificativo se non  vuoto
			 AConnexionTD.ModifierIdentifiantTDOption (Result, LOptionIdent);
		  }
		}
	  } catch {}
	  return Result;
	}

	public UInt32 AccederOuCreerEtudiant (HpSvcWEtudiantsClient AConnexionEtudiants,
										  string ANom,
										  string APrenom,
										  string ADate,
										  string AIdent){

	  UInt32 Result = 0;
      DateTime LDate;
	  try { // converte la stringa in data
		LDate = Convert.ToDateTime (ADate);
	  } catch {
	    // Data predefinita in HP
		LDate = DateTime.MinValue.Date.AddYears(1898);
	  }
	  try {
		if (AIdent != ""){   // se c' l'identificativo
		  Result = AConnexionEtudiants.AccederEtudiantParIdentifiant (AIdent);
		  if (ANom != "")    // modifica il cognome se non  vuoto
			AConnexionEtudiants.ModifierNomEtudiant (Result, ANom);
		  if (APrenom != "") // modifica il nome se non  vuoto
			AConnexionEtudiants.ModifierPrenomEtudiant (Result, APrenom);
		  if (ADate != "")   // modifica la data di nascita se non  vuota
			AConnexionEtudiants.ModifierDateDeNaissanceEtudiant (Result, LDate.ToString("o"));
		} else { // se non c' l'identificativo, accede allo studente attraverso il cognome, il nome e la data di nascita
			Result = AConnexionEtudiants.AccederEtudiantsParNomPrenomEtDateDeNaissance (ANom, APrenom, LDate.ToString("o")) [0];
		}
	  } catch {
		try { // cerca di creare lo studente
		  Result = AConnexionEtudiants.CreerEtudiantAvecIdentifiant (ANom, APrenom, LDate.ToString("o"), AIdent);
		} catch {
		  // L'identificativo viene nuovamente definito ma lo studente esiste gi nella base dati
		  Result = AConnexionEtudiants.AccederEtudiantsParNomPrenomEtDateDeNaissance (ANom, APrenom, LDate.ToString("o")) [0];
		  if (AIdent != "") // modifica l'identificativo se non  vuoto
			AConnexionEtudiants.ModifierIdentifiantEtudiant (Result, AIdent);
		}
	  }
	  return Result;
	}

	public Boolean ColonneDiplomeEstUnTD (String ALibelle, String AIdentifiant) {
	  Boolean Result = false;

	  string delimStr = "<>"; //<Corso><Suddivisione>Gruppo  // 1 3 4

	  string [] splitLibelle = null;
	  string [] splitIdent   = null;
	  char [] delimiter = delimStr.ToCharArray();

	  try {
		splitLibelle = ALibelle.Split (delimiter);
		splitIdent   = AIdentifiant.Split (delimiter);

		if (splitIdent.Length == 5)   // se la stringa  sotto forma di <ident_del_corso><suddivisione>ident_del_gruppo
		  Result = true;
		if (splitLibelle.Length == 5) // se la stringa  sotto forma di <nome_del_corso><suddivisione>nome_del_gruppo
		  Result = true;
	  } catch {}
	  return Result;
	}

	public Boolean ColonneDiplomeEstUneOption (String ALibelle, String AIdentifiant) {
	  Boolean Result = false;

	  string delimStr = "<>"; //<Corso>Opzione  // 1 2

	  string [] splitLibelle = null;
	  string [] splitIdent   = null;
	  char [] delimiter = delimStr.ToCharArray();

	  try {
		splitLibelle = ALibelle.Split (delimiter);
		splitIdent   = AIdentifiant.Split (delimiter);

		if (splitIdent.Length == 3)   // se la stringa  sotto forma di <ident_del_corso>ident_della_opzione
		  Result = true;
		if (splitLibelle.Length == 3) // se la stringa  sotto forma di <nome_del_corso>nome_della_opzione
		  Result = true;
	  } catch {}
	  return Result;
	}

	public void MajEtudiants(HpSvcWEtudiantsClient AConnexionEtudiants, HpSvcWPromotionsClient AConnexionPromotions, HpSvcWTDOptionsClient AConnexionTDOptions){
	  int counter = 0;
	  string line;
	  string EtudiantIdent;
	  string EtudiantNom;
	  string EtudiantPrenom;
	  string EtudiantDate;
	  string EtudiantProprietaire;
	  string EtudiantNumero;
	  string EtudiantMail;
	  string EtudiantSexe;
	  string DiplomeIdent;
	  string DiplomeCode;
	  string DiplomeLibelle;
	  string DiplomeProprietaire;
	  string delimStr = ";,	"; //Separatori : ; o , o Tab
	  string [] split = null;
	  int SplitEleveIdent    = -1;
	  int SplitEleveNom      = -1;
	  int SplitElevePrenom   = -1;
	  int SplitEleveDate     = -1;
	  int SplitEleveProprio  = -1;
	  int SplitDiplomeIdent  = -1;
	  int SplitDiplomeCode   = -1;
	  int SplitDiplomeNom    = -1;
	  int SplitDiplomeProprio= -1;
	  int SplitEleveNumNat   = -1;
	  int SplitEleveMail     = -1;
	  int SplitEleveSexe     = -1;
	  char [] delimiter = delimStr.ToCharArray();
	  UInt32 EtudiantCourant;
	  UInt32 DiplomeCourant;

	  // Legge il file linea per linea
	  try {
		 System.IO.StreamReader file = new System.IO.StreamReader (".\\AggiornamentoStudente.txt",
																   System.Text.Encoding.Default);
		// inizializza i numeri della colonna sulla prima linea
		if ((line = file.ReadLine()) != null) {
		  split = line.Split (delimiter);
		  for (int i= 0; i < split.Length; i++) {
			switch (split [i].ToUpper())  {
			  case "IDENT_ETU"     : SplitEleveIdent = i;
			  break;
			  case "NOM_ETU"       : SplitEleveNom = i;
			  break;
			  case "PRENOM_ETU"    : SplitElevePrenom = i;
			  break;
			  case "DATE_ETU"      : SplitEleveDate = i;
			  break;
			  case "PROP_ETU"      : SplitEleveProprio = i;
			  break;
			  case "IDENT_DIP"     : SplitDiplomeIdent = i;
			  break;
			  case "CODE_DIP"      : SplitDiplomeCode = i;
			  break;
			  case "NOM_DIP"       : SplitDiplomeNom = i;
			  break;
			  case "PROP_DIP"      : SplitDiplomeProprio = i;
			  break;
			  case "NUMERONAT_ETU" : SplitEleveNumNat = i;
			  break;
			  case "EMAIL_ETU"     : SplitEleveMail = i;
			  break;
			  case "SEXE_ETU"      : SplitEleveSexe = i;
			  break;
			}
		  }
		}

		while ((line = file.ReadLine()) != null) {
		  split = line.Split (delimiter);
		  try {
			EtudiantIdent        = "";
			EtudiantNom 	     = "";
			EtudiantPrenom       = "";
			EtudiantDate         = "";
			EtudiantProprietaire = "";
			DiplomeIdent         = "";
			DiplomeCode          = "";
			DiplomeLibelle       = "";
			DiplomeProprietaire  = "";
			EtudiantNumero       = "";
			EtudiantMail         = "";
			EtudiantSexe         = "";
			if (SplitEleveIdent     != -1)
			EtudiantIdent            = split[SplitEleveIdent];
			if (SplitEleveNom       != -1)
			EtudiantNom 	         = split[SplitEleveNom];
			if (SplitElevePrenom    != -1)
			EtudiantPrenom           = split[SplitElevePrenom];
			if (SplitEleveDate      != -1)
			EtudiantDate             = split[SplitEleveDate];
			if (SplitEleveProprio   != -1)
			EtudiantProprietaire     = split[SplitEleveProprio];
			if (SplitDiplomeIdent   != -1)
			DiplomeIdent             = split[SplitDiplomeIdent];
			if (SplitDiplomeCode    != -1)
			DiplomeCode              = split[SplitDiplomeCode];
			if (SplitDiplomeNom     != -1)
			DiplomeLibelle           = split[SplitDiplomeNom];
			if (SplitDiplomeProprio != -1)
			DiplomeProprietaire      = split[SplitDiplomeProprio];
			if (SplitEleveNumNat    != -1)
			EtudiantNumero           = split[SplitEleveNumNat];
			if (SplitEleveMail      != -1)
			EtudiantMail             = split[SplitEleveMail];
			if (SplitEleveSexe      != -1)
			EtudiantSexe             = split[SplitEleveSexe];

			// Studente
			EtudiantCourant = AccederOuCreerEtudiant (AConnexionEtudiants, EtudiantNom, EtudiantPrenom, EtudiantDate, EtudiantIdent);
			try { // Modifica del proprietario
			  if (SplitEleveProprio      != -1)
				if (EtudiantProprietaire != "")
  				  AConnexionEtudiants.ModifierProprietaireEtudiant (EtudiantCourant, EtudiantProprietaire, "");
			} catch {}
			try { // Modifica del codice fiscale
			  if (SplitEleveNumNat      != -1)
				if (EtudiantNumero != "")
				  AConnexionEtudiants.ModifierNumeroDOrdreEtudiant (EtudiantCourant, EtudiantNumero);
			} catch {}
			try { // Modifica dell'E-Mail
			  if (SplitEleveMail      != -1)
				if (EtudiantMail != "")
				  AConnexionEtudiants.ModifierEMailEtudiant (EtudiantCourant, EtudiantMail);
			} catch {}
			try { // Modifica del sesso
			  if (SplitEleveSexe      != -1)
				if (EtudiantSexe != "")
				  AConnexionEtudiants.ModifierSexeEtudiant (EtudiantCourant, EtudiantSexe);
			} catch {}

			if (ColonneDiplomeEstUnTD (DiplomeLibelle, DiplomeIdent)) {	        // Gruppo
			  DiplomeCourant = AccederOuCreerTD (AConnexionTDOptions, AConnexionPromotions, DiplomeLibelle, DiplomeCode, DiplomeIdent);
			  try { // Modifica del proprietario
				if (SplitDiplomeProprio      != -1)
				  if (DiplomeProprietaire != "")
				  AConnexionTDOptions.ModifierProprietaireTDOption (DiplomeCourant, DiplomeProprietaire, "");
			  } catch {}

			  try { // Modifica del gruppo dello studente
				AConnexionEtudiants.AjouterEtudiantATDOption (EtudiantCourant, DiplomeCourant);
			  } catch {}
			}else{  // opzione o corso
			  if (ColonneDiplomeEstUneOption (DiplomeLibelle, DiplomeIdent)) {	// opzione
				DiplomeCourant = AccederOuCreerOption (AConnexionTDOptions, AConnexionPromotions, DiplomeLibelle, DiplomeCode, DiplomeIdent);
				try { // Modifica del proprietario
				  if (SplitDiplomeProprio      != -1)
					if (DiplomeProprietaire != "")
					  AConnexionTDOptions.ModifierProprietaireTDOption (DiplomeCourant, DiplomeProprietaire , "");
				} catch {}

				try { // Modifica del gruppo dello studente
				  AConnexionEtudiants.AjouterEtudiantATDOption (EtudiantCourant, DiplomeCourant);
				} catch {}
			  }else{                                                            // Corso
				DiplomeCourant = AccederOuCreerDiplome (AConnexionPromotions, DiplomeLibelle, DiplomeCode, DiplomeIdent);
				try { // Modifica del proprietario
				  if (SplitDiplomeProprio      != -1)
					if (DiplomeProprietaire != "")
				      AConnexionPromotions.ModifierProprietairePromotion (DiplomeCourant, DiplomeProprietaire, "");
				} catch {}

				try { // Modifica del corso dello studente
				  AConnexionEtudiants.AjouterEtudiantALaPromotion (EtudiantCourant, DiplomeCourant);
				} catch {}
			  }
			}
			counter++;
		  } catch {}
		}
		Console.WriteLine ("Aggiornamento degli studenti eseguito (" + counter + " linee lette).");

		file.Close();
	  } catch {
		Console.WriteLine ("Impossibile trovare il file riguardante gli studenti : '.\\AggiornamentoStudente.txt'");
	  }
	}

	public void MajEnseignants (HpSvcWEnseignantsClient AConnexionEnseignants){
	  int counter = 0;
	  string line;
	  string EnseignantIdent;
	  string EnseignantCode;
	  string EnseignantNom;
	  string EnseignantPrenom;
	  string EnseignantDate;
	  string EnseignantProprietaire;
	  string EnseignantMail;
	  string EnseignantCivilite;
	  string EnseignantAdresse1;
	  string EnseignantAdresse2;
	  string EnseignantCodePostal;
	  string EnseignantVille;
	  string delimStr = ";,	"; //Separatori : ; o , o Tab
	  string [] split = null;
	  int SplitProfIdent    = -1;
	  int SplitProfCode     = -1;
	  int SplitProfNom      = -1;
	  int SplitProfPrenom   = -1;
	  int SplitProfDate     = -1;
	  int SplitProfProprio  = -1;
	  int SplitProfMail     = -1;
	  int SplitProfCivilite = -1;
	  int SplitProfAdr1     = -1;
	  int SplitProfAdr2     = -1;
	  int SplitProfCodePost = -1;
	  int SplitProfVille    = -1;
	  char [] delimiter = delimStr.ToCharArray();
	  DateTime LDate;
	  UInt32 EnseignantCourant;

	  // Lettura del file linea per linea
	  try {
		System.IO.StreamReader file = new System.IO.StreamReader(".\\AggiornamentoDocente.txt",
																 System.Text.Encoding.Default);
		// inizializza i numeri della colonna sulla prima linea
		if ((line = file.ReadLine()) != null) {
		  split = line.Split (delimiter);
		  for (int i= 0; i < split.Length; i++) {
			switch (split [i].ToUpper())  {
			  case "IDENT_ENS"      : SplitProfIdent = i;
			  break;
			  case "CODE_ENS"       : SplitProfCode = i;
			  break;
			  case "NOM_ENS"        : SplitProfNom = i;
			  break;
			  case "PRENOM_ENS"     : SplitProfPrenom = i;
			  break;
			  case "DATE_ENS"       : SplitProfDate = i;
			  break;
			  case "PROP_ENS"       : SplitProfProprio = i;
			  break;
			  case "EMAIL_ENS"      : SplitProfMail = i;
			  break;
			  case "CIV_ENS"        : SplitProfCivilite = i;
			  break;
			  case "ADR1_ENS"       : SplitProfAdr1 = i;
			  break;
			  case "ADR2_ENS"       : SplitProfAdr2 = i;
			  break;
			  case "CODEPOSTAL_ENS" : SplitProfCodePost = i;
			  break;
			  case "VILLE_ENS"      : SplitProfVille = i;
			  break;
			}
		  }
		}
		// legge i dati
		while ((line = file.ReadLine()) != null) {
		  split = line.Split (delimiter);
		  try {
			EnseignantIdent        = "";
			EnseignantCode 	       = "";
			EnseignantNom 	       = "";
			EnseignantPrenom       = "";
			EnseignantDate         = "";
			EnseignantProprietaire = "";
			EnseignantMail         = "";
			EnseignantCivilite     = "";
			EnseignantAdresse1     = "";
			EnseignantAdresse2     = "";
			EnseignantCodePostal   = "";
			EnseignantVille        = "";
			if (SplitProfIdent    != -1)
			EnseignantIdent        = split [SplitProfIdent];
			if (SplitProfCode     != -1)
			EnseignantCode 	       = split [SplitProfCode];
			if (SplitProfNom      != -1)
			EnseignantNom 	       = split [SplitProfNom];
			if (SplitProfPrenom   != -1)
			EnseignantPrenom       = split [SplitProfPrenom];
			if (SplitProfDate     != -1)
			EnseignantDate         = split [SplitProfDate];
			if (SplitProfProprio  != -1)
			EnseignantProprietaire = split [SplitProfProprio];
			if (SplitProfMail     != -1)
			EnseignantMail         = split [SplitProfMail];
			if (SplitProfCivilite != -1)
			EnseignantCivilite     = split [SplitProfCivilite];
			if (SplitProfAdr1     != -1)
			EnseignantAdresse1     = split [SplitProfAdr1];
			if (SplitProfAdr2     != -1)
			EnseignantAdresse2     = split [SplitProfAdr2];
			if (SplitProfCodePost != -1)
			EnseignantCodePostal   = split [SplitProfCodePost];
			if (SplitProfVille    != -1)
			EnseignantVille        = split [SplitProfVille];

			EnseignantCourant = AccederOuCreerEnseignant (AConnexionEnseignants,
														  EnseignantNom,
														  EnseignantPrenom,
														  EnseignantCode,
														  EnseignantIdent);
			try { // Modifica la data di nascita
			  if (SplitProfDate     != -1)
				if (EnseignantDate != "") {
				  LDate = Convert.ToDateTime (EnseignantDate);
				  AConnexionEnseignants.ModifierDateDeNaissanceEnseignant(EnseignantCourant, LDate.ToString("o"));
				}
			} catch {}
			try { // Modifica il proprietario
			  if (SplitProfProprio  != -1)
				if (EnseignantProprietaire != "")
				  AConnexionEnseignants.ModifierProprietaireEnseignant  (EnseignantCourant,
																		 EnseignantProprietaire, "");
			} catch {}
			try { // Modifica l'indirizzo mail
			  if (SplitProfMail     != -1)
				if (EnseignantMail != "")
				  AConnexionEnseignants.ModifierEMailEnseignant  (EnseignantCourant,
																  EnseignantMail);
			} catch {}
			try { // Modifica il titolo
			  if (SplitProfCivilite != -1)
				if (EnseignantCivilite != "")
				  AConnexionEnseignants.ModifierCiviliteEnseignant  (EnseignantCourant,
																	 EnseignantCivilite);
			} catch {}
			try { // Modifica l'indirizzo 1
			  if (SplitProfAdr1 != -1)
				if (EnseignantAdresse1 != "")
				  AConnexionEnseignants.ModifierAdresse1Enseignant  (EnseignantCourant,
																	 EnseignantAdresse1);
			} catch {}
			try { // Modifica l'indirizzo 2
			  if (SplitProfAdr2 != -1)
				if (EnseignantAdresse2 != "")
				  AConnexionEnseignants.ModifierAdresse2Enseignant  (EnseignantCourant,
									   							     EnseignantAdresse2);
			} catch {}
			try { // Modifica il codice postale
			  if (SplitProfCodePost != -1)
				if (EnseignantCodePostal != "")
				  AConnexionEnseignants.ModifierCodePostalEnseignant  (EnseignantCourant,
																       EnseignantCodePostal);
			} catch {}
			try { // Modifica la citt
			  if (SplitProfVille  != -1)
				if (EnseignantVille != "")
				  AConnexionEnseignants.ModifierVilleEnseignant  (EnseignantCourant,
																  EnseignantVille);
			} catch {}
			counter++;
		  } catch {}
		}
		Console.WriteLine ("Aggiornamento dei docenti eseguito (" + counter + " linee lette).");

		file.Close();
	  } catch {
		Console.WriteLine ("Impossibile trovare il file riguardante i docenti : '.\\AggiornamentoDocente.txt'");
	  }
	}

	static void Main (string[] args) {
	  String StrAdresse;
	  String StrPort;
      String StrRacine;
      String StrLogin;
	  String StrMDP;
	  if (args.Length < 4) {
        Console.WriteLine ("C# - V 1.4");
        Console.WriteLine ("----------");
        Console.WriteLine ("");
		Console.WriteLine ("Connessione a HYPERPLANNING WEB Service");
		Console.WriteLine ("-------------------------------------");
		Console.WriteLine ("");
		Console.WriteLine ("Inserire l'indirizzo del web service poi premere <invio> :");
		StrAdresse  = Console.ReadLine();
		Console.WriteLine ("");
		Console.WriteLine ("Inserire la porta del web service poi premere <invio> :");
		StrPort  = Console.ReadLine();
        Console.WriteLine("");
        Console.WriteLine("Inserire la radice del web service poi premere <invio> :");
        StrRacine = Console.ReadLine();
		Console.WriteLine ("");
		Console.WriteLine ("Inserire il nome utente poi premere <invio> :");
		StrLogin  = Console.ReadLine();
		Console.WriteLine ("");
		Console.WriteLine ("Inserire la password poi premere <invio> :");
		StrMDP    = Console.ReadLine();
	  } else {
		StrAdresse  = args[0];
		StrPort     = args[1];
        StrRacine   = args[2];
        StrLogin    = args[3];
		StrMDP      = args[4];
	  }
	  Console.WriteLine ("");
	  Console.WriteLine ("--------------------------------------------------");
	  Console.WriteLine ("");

	  string URLSvcW = "http://" + StrAdresse + ":" + StrPort + "/" + StrRacine;
	  try {
          AuthentificationHpSvcW lAuthentification = new AuthentificationHpSvcW(StrLogin, StrMDP);
          // Dichiarazione
          HpSvcWAdminClient       lAdmin       = new HpSvcWAdminClient();
          HpSvcWEtudiantsClient   lEtudiants   = new HpSvcWEtudiantsClient();
          HpSvcWPromotionsClient  lPromotions  = new HpSvcWPromotionsClient();
          HpSvcWEnseignantsClient lEnseignants = new HpSvcWEnseignantsClient();
          HpSvcWTDOptionsClient   lTDOptions   = new HpSvcWTDOptionsClient();

		  // Assegnazione dell'account di accesso agli oggetti
          lAdmin.Endpoint.Behaviors.Add(lAuthentification);
          lEtudiants.Endpoint.Behaviors.Add(lAuthentification);
          lPromotions.Endpoint.Behaviors.Add(lAuthentification);
          lEnseignants.Endpoint.Behaviors.Add(lAuthentification);
          lTDOptions.Endpoint.Behaviors.Add(lAuthentification);

          // inizializza l'indirizzo su cui si trova il web service
          string lAdresseAdmin      = lAdmin.Endpoint.Address.ToString();
          string lAdresseEtudiant   = lEtudiants.Endpoint.Address.ToString();
          string lAdressePromotion  = lPromotions.Endpoint.Address.ToString();
          string lAdresseEnseignant = lEnseignants.Endpoint.Address.ToString();
          string lAdresseTDOption   = lTDOptions.Endpoint.Address.ToString();
          lAdmin.Endpoint.Address       = new EndpointAddress(URLSvcW + lAdresseAdmin.Substring(lAdresseAdmin.LastIndexOf("/")));
          lEtudiants.Endpoint.Address   = new EndpointAddress(URLSvcW + lAdresseEtudiant.Substring(lAdresseEtudiant.LastIndexOf("/")));
          lPromotions.Endpoint.Address  = new EndpointAddress(URLSvcW + lAdressePromotion.Substring(lAdressePromotion.LastIndexOf("/")));
          lEnseignants.Endpoint.Address = new EndpointAddress(URLSvcW + lAdresseEnseignant.Substring(lAdresseEnseignant.LastIndexOf("/")));
          lTDOptions.Endpoint.Address   = new EndpointAddress(URLSvcW + lAdresseTDOption.Substring(lAdresseTDOption.LastIndexOf("/")));
     
		//Visualizzazion edella versione
		Console.WriteLine (lAdmin.Version () + " connect");
		Console.WriteLine ("");
		Console.WriteLine ("--------------------------------------------------");
		Console.WriteLine ("");

		TestHpSvcWDotNet SWeb = new TestHpSvcWDotNet ();
		SWeb.MajEnseignants (lEnseignants);
		SWeb.MajEtudiants (lEtudiants, lPromotions, lTDOptions);
	  } catch {
		Console.WriteLine ("Il web service di Hyperplanning non  stato trovato.");
		Console.WriteLine ("Siete pregati di verificare : ");
		Console.WriteLine ("- che l'orario sia pubblicato attraverso il web service di Hyperplanning");
		Console.WriteLine ("- nome utente e password (quelli dell'utente che ha avviato il web service)");
		Console.WriteLine ("- i parametri di comunicazione (URL del web service : " + URLSvcW + ")");
	  }
	  Console.WriteLine ("");
	  Console.WriteLine ("Peremere <invio> per finire il programma...");
	  Console.ReadLine();
	}
  }
}


