from requests import Session
from requests.auth import HTTPBasicAuth
from zeep import Client
from zeep.transports import Transport

session = Session()
session.auth = HTTPBasicAuth("MyLogin", "MyPassword")

lPrefixeWsdl='http://monserveur/hpsw/wsdl/'

# Interfacce utilizzate
Matiere = Client(lPrefixeWsdl + 'IHpSvcWMatieres', transport=Transport(session=session))
Admin = Client(lPrefixeWsdl + 'IHpSvcWAdmin', transport=Transport(session=session))

# Visualizzazione della versione
print ('Connesso a ' + Admin.service.Version());
    
# Visualizzazione del numero di materie
print ('Ci sono ' + str(Matiere.service.NombreMatieres()) + ' materie nella base dati ');

# Visualizzazione dell'elenco delle materie
lCles = Matiere.service.TrierTableauDeMatieresParLibelleEtCode ({'THpSvcWCleMatiere' : Matiere.service.ToutesLesMatieres()});
lClesIn = {'THpSvcWCleMatiere' : lCles};
lCodes = Matiere.service.CodesTableauDeMatieres(lClesIn);
lLibelles = Matiere.service.LibellesTableauDeMatieres(lClesIn);
lLibellesLongs = Matiere.service.LibellesLongsTableauDeMatieres(lClesIn);

for i in range (len (lCles)): 
    print (str(lCles[i]) + ' '  + str(lCodes[i] if lCodes[i] is not None else '') + ' '  + str(lLibelles[i]) + ' : '  + str(lLibellesLongs[i] if lLibellesLongs[i] is not None else '-'))
