﻿# Chiudi l’esecuzione al primo errore
$ErrorActionPreference='stop';

[String]$lPrefixeWsdl='http://monserveur/hpsw/wsdl/SansTypeSimple';

# Finestra di autenticazione
$lIdentification = Get-Credential;

# Interfacce utilizzate
$lAdmin = New-WebServiceProxy -uri "$lPrefixeWsdl/IHpSvcWAdmin" -Credential $lIdentification;
$lMatieres = New-WebServiceProxy -uri "$lPrefixeWsdl/IHpSvcWMatieres" -Credential $lIdentification;

# Visualizzazione della versione
"Connesso a " + $lAdmin.Version();

# Visualizzazione del numero di materie
"Ci sono {0:D} materie nella base dati" -f $lMatieres.NombreMatieres();

# Visualizzazione dell'elenco delle materie
$lCles = $lMatieres.ToutesLesMatieres();
$lCles = $lMatieres.TrierTableauDeMatieresParLibelleEtCode($lCles);
$lCodes = $lMatieres.CodesTableauDeMatieres($lCles);
$lLibelles = $lMatieres.LibellesTableauDeMatieres($lCles);
$lLibellesLongs = $lMatieres.LibellesLongsTableauDeMatieres($lCles);
for ($lIndice = 0; $lIndice -lt $lCles.Count; $lIndice++) {"{0,3:D} {1,-8} {2,-20} {3}" -f $lCles[$lIndice], $lCodes[$lIndice], $lLibelles[$lIndice], $lLibellesLongs[$lIndice]};
